<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:decimal-format name="pt" decimal-separator="," grouping-separator="." infinity="Infinito" minus-sign="-" NaN="0,00" percent="%" per-mille="m" zero-digit="0" digit="#" pattern-separator=";" />

    <!-- TEMPLATE DE FORMATAÇÃO DE DATAS -->
    <xsl:template name="format-date">

        <xsl:param name="date" />

        <xsl:variable name="year" select="substring($date, 1, 4)" />
        <xsl:variable name="month" select="substring($date, 6, 2)" />
        <xsl:variable name="day" select="substring($date, 9, 2)" />
        <xsl:variable name="hour" select="substring($date, 12, 2)" />
        <xsl:variable name="minute" select="substring($date, 15, 2)" />
        <xsl:variable name="second" select="substring($date, 18, 2)" />

        <xsl:if test="$date != ''">
            <xsl:value-of select="$day"/>/<xsl:value-of select="$month"/>/<xsl:value-of select="$year"/>
            
            <xsl:if test="$hour != ''">
                - <xsl:value-of select="$hour"/>:<xsl:value-of select="$minute"/>:<xsl:value-of select="$second"/>
            </xsl:if>
            
        </xsl:if>

    </xsl:template>

    <!-- TEMPLATE DE FORMATAÇÃO DE TEMPO-->
    <xsl:template name="format-time">

      <xsl:param name="date" />

      <xsl:variable name="hour" select="substring($date, 12, 2)" />
      <xsl:variable name="minute" select="substring($date, 15, 2)" />
      <xsl:variable name="second" select="substring($date, 18, 2)" />

      <xsl:if test="$date != ''">
        
        <xsl:if test="$hour != ''">
          <xsl:value-of select="$hour"/>:<xsl:value-of select="$minute"/>:<xsl:value-of select="$second"/>
        </xsl:if>

      </xsl:if>

    </xsl:template>

    <!-- TEMPLATE DE FORMATAÇÃO APENAS DE DATAS -->
    <xsl:template name="format-date-only">

      <xsl:param name="date" />

      <xsl:variable name="year" select="substring($date, 1, 4)" />
      <xsl:variable name="month" select="substring($date, 6, 2)" />
      <xsl:variable name="day" select="substring($date, 9, 2)" />
      
      <xsl:if test="$date != ''">
        <xsl:value-of select="$day"/>/<xsl:value-of select="$month"/>/<xsl:value-of select="$year"/>
      </xsl:if>

    </xsl:template>

    <!-- TEMPLATE DE FORMATAÇÃO DE CNPJ -->
    <xsl:template name="format-cnpj">
        
        <xsl:param name="cnpj" />

        <xsl:variable name="prefix">
            <xsl:value-of select="substring($cnpj, 1, 2)"/>.<xsl:value-of select="substring($cnpj, 3, 3)"/>.<xsl:value-of select="substring($cnpj, 6, 3)"/>
        </xsl:variable>

        <xsl:variable name="suffix">
            <xsl:value-of select="substring($cnpj, 9, 4)"/>-<xsl:value-of select="substring($cnpj, 13, 2)"/>
        </xsl:variable>

        <xsl:value-of select="$prefix"/>/<xsl:value-of select="$suffix"/>

    </xsl:template>
    
    <!-- TEMPLATE DE FORMATAÇÃO DE CPF -->
    <xsl:template name="format-cpf">
        
        <xsl:param name="cpf" />
        <xsl:value-of select="substring($cpf, 1, 3)"/>.<xsl:value-of select="substring($cpf, 4, 3)"/>.<xsl:value-of select="substring($cpf, 7, 3)"/>-<xsl:value-of select="substring($cpf, 10, 2)"/>

    </xsl:template>
    
    <!-- TEMPLATE DE FORMATAÇÃO DE CEP -->
    <xsl:template name="format-cep">

        <xsl:param name="cep" />

        <xsl:value-of select="substring($cep, 1, 5)"/>-<xsl:value-of select="substring($cep, 6, 3)"/>
        
    </xsl:template>
    
    <!-- TEMPLATE DE FORMATAÇÃO DE TELEFONE -->
    <xsl:template name="format-phone">
        
        <xsl:param name="phone" />

        <xsl:variable name="area">
            (<xsl:value-of select="substring($phone, 1, 2)"/>)
        </xsl:variable>

        <xsl:variable name="suffix">
            <xsl:value-of select="substring($phone, 3, 4)"/> - <xsl:value-of select="substring($phone, 7, 4)"/>
        </xsl:variable>

        <xsl:if test="$phone != ''">
            <xsl:value-of select="$area"/>
            <xsl:value-of select="$suffix"/>
        </xsl:if>
        
    </xsl:template>

    <!-- TEMPLATE QUE FORMATA A CHAVE DE ACESSO -->
    <xsl:template name="format-chave-acesso">
        
        <xsl:param name="chave" />

        <xsl:value-of select="substring($chave, 1, 4)"/>.<xsl:value-of select="substring($chave, 5, 4)"/>.<xsl:value-of select="substring($chave, 9, 4)"/>.<xsl:value-of select="substring($chave, 13, 4)"/>.<xsl:value-of select="substring($chave, 17, 4)"/>.<xsl:value-of select="substring($chave, 21, 4)"/>.<xsl:value-of select="substring($chave, 25, 4)"/>.<xsl:value-of select="substring($chave, 29, 4)"/>.<xsl:value-of select="substring($chave, 33, 4)"/>.<xsl:value-of select="substring($chave, 37, 4)"/>.<xsl:value-of select="substring($chave, 41, 4)"/>
    
    </xsl:template>

    <!-- TEMPLATE DE EXIBIÇÃO DE NÚMERO DECIMAL -->
    <xsl:template name="decimal">
        
        <xsl:param name="value"/>
        <xsl:param name="count"/>

        <xsl:choose>
            <xsl:when test="$count = 3"><xsl:value-of select="format-number($value, '#.##0,000', 'pt')"/></xsl:when>
            <xsl:when test="$count = 4"><xsl:value-of select="format-number($value, '#.##0,0000', 'pt')"/></xsl:when>
            <xsl:when test="$count = 6"><xsl:value-of select="format-number($value, '#.##0,000000', 'pt')"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="format-number($value, '#.##0,00', 'pt')"/></xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>

    <!-- FORMATA O ENDEREÇO DE UM ROOT -->
    <xsl:template name="format-ender" xmlns:cte="http://www.portalfiscal.inf.br/cte">
        
        <xsl:param name="root" />

        <xsl:value-of select="$root/descendant::cte:xLgr "/>
        <xsl:if test="$root/descendant::cte:nro != ''">, <xsl:value-of select="$root/descendant::cte:nro "/></xsl:if>
        <xsl:if test="$root/descendant::cte:xCpl != ''">, <xsl:value-of select="$root/descendant::cte:xCpl "/></xsl:if>
        
    </xsl:template>

    <!-- TEMPLATE QUE TRATA A EXIBIÇÃO DOS DADOS DE ENTRADA -->
    <xsl:template name="get-fields" xmlns:cte="http://www.portalfiscal.inf.br/cte">
        <xsl:param name="root" />

        <table class="table" cellpadding="2" cellspacing="1">

            <!-- TRATA PESSOA FÍSICA OU PESSOA JURÍDICA -->
            <xsl:choose>
                <xsl:when test="count($root/cte:CNPJ) = 0">
                    <!-- PESSOA FISICA -->
                    <tr>
                        <th width="30%">CPF</th>
                        <th width="40%">Nome</th>
                        <th width="30%">UF</th>
                    </tr>
                    <tr>
                        <td><xsl:call-template name="format-cpf"><xsl:with-param name="cpf" select="$root/cte:CPF"/></xsl:call-template></td>
                        <td><xsl:value-of select="$root/cte:xNome" /></td>
                        <td><xsl:value-of select="$root/descendant::cte:UF" /></td>
                    </tr>
                </xsl:when>
                <xsl:otherwise>
                    <!-- PESSOA JURÍDICA -->
                    <tr>
                        <th width="20%">CNPJ</th>
                        <th width="40%">Nome / Razão Social</th>
                        <th width="20%">Inscrição Estadual</th>
                        <th width="20%">UF</th>
                    </tr>
                    <tr>
                        <td>
                            <xsl:call-template name="format-cnpj">
                                <xsl:with-param name="cnpj" select="$root/cte:CNPJ"/>
                            </xsl:call-template>
                        </td>
                        <td><xsl:value-of select="$root/cte:xNome" /></td>
                        <td><xsl:value-of select="$root/cte:IE" /></td>
                        <td><xsl:value-of select="$root/descendant::cte:UF" /></td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>
        </table>
    </xsl:template>
    
    <!-- GERA O TÍTULO DA ABA -->
    <xsl:template name="group">
        <xsl:param name="label" />
        <table class="group" cellpadding="0" cellspacing="0">
            <tr>
                <td width="10%"><hr size="1" noshade="true" /></td>
                <td width="25%"><xsl:value-of select="$label" /></td>
                <td><hr size="1" noshade="true" /></td>
            </tr>
        </table>
    </xsl:template>
    
    <!-- TEMPLATE QUE TRATA A EXIBIÇÃO DOS DADOS DE ENTRADA -->
    <xsl:template name="tomador" xmlns:cte="http://www.portalfiscal.inf.br/cte">
        <xsl:param name="root" />
        <xsl:param name="label" />
        
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Dados do Tomador'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Nome / Razão Social</th>
                <th width="50%">Nome Fantasia</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$root/cte:xNome" /></td>
                <td><xsl:value-of select="$root/cte:xFant" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$root" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                <th>Inscrição Estadual</th>
            </tr>
            <tr>
                <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$root" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                <td><xsl:value-of select="$root/cte:IE" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Endereço</th>
                <th>Bairro / Distrito</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-ender"><xsl:with-param name="root" select="$root" /></xsl:call-template></td>
                <td><xsl:value-of select="$root/descendant::cte:xBairro" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Fone / Fax</th>
                <th>CEP</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-phone"><xsl:with-param name="phone" select="$root/descendant::cte:fone" /></xsl:call-template></td>
                <td><xsl:call-template name="format-cep"><xsl:with-param name="cep" select="$root/descendant::cte:CEP" /></xsl:call-template></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Município</th>
                <th>UF</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$root/descendant::cte:xMun" /></td>
                <td><xsl:value-of select="$root/descendant::cte:UF" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>País</th>
                <th>Relação com a carga</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$root/descendant::cte:xPais" /></td>
                <td><xsl:value-of select="$label" /></td>
            </tr>
        </table>
    </xsl:template>

    <!-- TEMPLATE QUE TRATA CPF OU CNPJ -->
    <xsl:template name="trata-pessoa" xmlns:cte="http://www.portalfiscal.inf.br/cte">
        <xsl:param name="root" />
        <xsl:param name="type" />

        <!-- TESTA SE É PESSOA FÍSICA OU PESSOA JURÍDICA -->
        <xsl:if test="$root/cte:CPF != ''">
            <xsl:if test="$type = 'header'">CPF</xsl:if>
            <xsl:if test="$type = 'value'">
                <xsl:call-template name="format-cpf">
                    <xsl:with-param name="cpf" select="$root/cte:CPF" />
                </xsl:call-template>
            </xsl:if>
        </xsl:if>

        <xsl:if test="$root/cte:CNPJ != ''">
            <xsl:if test="$type = 'header'">CNPJ</xsl:if>
            <xsl:if test="$type = 'value'">
                <xsl:call-template name="format-cnpj">
                    <xsl:with-param name="cnpj" select="$root/cte:CNPJ" />
                </xsl:call-template>
            </xsl:if>
        </xsl:if>

    </xsl:template>
</xsl:stylesheet>