<?xml version="1.0" encoding="iso-8859-1" ?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n="http://www.portalfiscal.inf.br/cte"
                xmlns:r="http://www.serpro.gov.br/cte/remessacte.xsd">
  <xsl:include href="../functions.xslt"/>
  <xsl:decimal-format decimal-separator="," grouping-separator="." />
  <xsl:output method="html" version="4.0" media-type="text/html" />
  <xsl:template match="/">
    <div class="Principal">
      <xsl:call-template name="group">
        <xsl:with-param name="label" select="'Autorizao de Uso'" />
      </xsl:call-template>
      <div align="right">
        <img id="print" src="../img/print-2.gif"  OnClick="javascript:window.print()" alt="Imprimir" />
      </div>
      <table class="textoVerdana7" width="100%">
        <tr>
          <td width="60%" colspan="3">
            <span class="TextoFundoBrancoNegrito">
              Chave de acesso<br />
            </span>
            <span class="linhaCinza">
              <xsl:call-template name="format-chave-acesso">
                <xsl:with-param name="chave" select="substring-after(/n:cteProc/n:CTe/n:infCte/@Id,'CTe')"/>
              </xsl:call-template>
            </span>
          </td>
        </tr>
        <tr>
          <td width="20%">
            <span class="TextoFundoBrancoNegrito">
              Nmero CT-e<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:CTe/n:infCte/n:ide/n:nCT" />
            </span>
          </td>
          <td width="10%" colspan="2">
            <span class="TextoFundoBrancoNegrito">
              Srie<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:CTe/n:infCte/n:ide/n:serie" />
            </span>
          </td>
        </tr>
        <tr>
          <td valign ="top" width="33%">
            <span class="TextoFundoBrancoNegrito">
              Nmero do Protocolo<br />
            </span>
            <span class="linhaCinza">
              <xsl:text> </xsl:text>
              <xsl:value-of select="/n:cteProc/n:protCTe/n:infProt/n:nProt" />
            </span>
          </td>
          <td valign ="top" width="33%" colspan="2">
            <span class="TextoFundoBrancoNegrito">
              Data de emisso<br />
            </span>
            <span class="linhaCinza">
              <xsl:variable name="dEmi" select="/n:cteProc/n:CTe/n:infCte/n:ide/n:dhEmi"/>
              <xsl:call-template name="format-date">
                <xsl:with-param name="date" select="$dEmi" />
              </xsl:call-template>
            </span>
          </td>
        </tr>
        <tr>
          <td class="header" colspan="3">
            Dados do Emitente
          </td>          
        </tr>
        <tr>
          <td valign ="top"  width="60%">
            <span class="TextoFundoBrancoNegrito">
              Razo Social do Emitente<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:CTe/n:infCte/n:emit/n:xNome" />
            </span>
          </td>
          <td valign ="top" width="30%">
            <span class="TextoFundoBrancoNegrito">
              CNPJ do Emitente<br />
            </span>
            <span class="linhaCinza">
              <xsl:call-template name="format-cnpj">
                <xsl:with-param name="cnpj" select="/n:cteProc/n:CTe/n:infCte/n:emit/n:CNPJ" />
              </xsl:call-template>
            </span>
          </td>
          <td valign ="top" width="10%">
            <span class="TextoFundoBrancoNegrito">
              UF<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:CTe/n:infCte/n:emit/n:enderEmit/n:UF" />
            </span>
          </td>
        </tr>
        <tr>
          <td class="header" colspan="3">
            Destinatrio
          </td>
        </tr>
        <tr>
          <td valign ="top" width="60%">
            <span class="TextoFundoBrancoNegrito">
              Razo Social do Destinatrio<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:CTe/n:infCte/n:dest/n:xNome" />
            </span>
          </td>
          <td valign ="top" width="30%">
            <span class="TextoFundoBrancoNegrito">
              CNPJ do Destinatrio<br />
            </span>
            <span class="linhaCinza">
              <xsl:call-template name="format-cnpj">
                <xsl:with-param name="cnpj" select="/n:cteProc/n:CTe/n:infCte/n:dest/n:CNPJ" />
              </xsl:call-template>
            </span>
          </td>
          <td valign ="top" width="10%">
            <span class="TextoFundoBrancoNegrito">
              UF<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:CTe/n:infCte/n:dest/n:enderDest/n:UF" />
            </span>
          </td>
        </tr>
        <tr>
          <td class="header" colspan="3">
            Data e hora da Autorizao de uso:
          </td>
        </tr>
        <tr>
          <td valign ="top" width="33%" colspan="3">
            <span class="TextoFundoBrancoNegrito">
              Autorizao<br />
            </span>
            <span class="linhaCinza">
              <xsl:call-template name="format-date-only">
                <xsl:with-param name="date" select="/n:cteProc/n:protCTe/n:infProt/n:dhRecbto" />
              </xsl:call-template>
              s
              <xsl:call-template name="format-time">
                <xsl:with-param name="date" select="/n:cteProc/n:protCTe/n:infProt/n:dhRecbto" />
              </xsl:call-template>
            </span>
          </td>
        </tr>
        <tr>
          <td valign ="top" width="50%" colspan="3">
            <span class="TextoFundoBrancoNegrito">
              <i>Digest Value</i> do CT-e<br />
            </span>
            <span class="linhaCinza">
              <xsl:value-of select="/n:cteProc/n:protCTe/n:infProt/n:digVal" />
            </span>
          </td>
        </tr>
        <tr>
          <td valign ="top" height="30" colspan="3">
            <table width="100%" cellpadding="2" cellspacing="1">
              <tr>
                <td valign="top" width="33%">
                  <span class="TextoFundoBrancoNegrito">
                    Base de clculo do ICMS<br />
                  </span>
                  <span class="linhaCinza">
                    <xsl:choose>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST00/n:vBC != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST00/n:vBC,'##.##.##0,00')" />                        
                      </xsl:when>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST20/n:vBC != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST20/n:vBC,'##.##.##0,00')" />
                      </xsl:when>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST80/n:vBC != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST80/n:vBC,'##.##.##0,00')" />
                      </xsl:when>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST90/n:vBC != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST90/n:vBC,'##.##.##0,00')" />
                      </xsl:when>
                    </xsl:choose>
                  </span>
                </td>
                <td valign="top" width="33%">
                  <span class="TextoFundoBrancoNegrito">
                    Valor do ICMS<br />
                  </span>
                  <span class="linhaCinza">
                    <xsl:choose>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST00/n:vICMS != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST00/n:vICMS,'##.##.##0,00')" />
                      </xsl:when>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST20/n:vICMS != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST20/n:vICMS,'##.##.##0,00')" />
                      </xsl:when>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST80/n:vICMS != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST80/n:vICMS,'##.##.##0,00')" />
                      </xsl:when>
                      <xsl:when test="/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST90/n:vICMS != ''">
                        <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:imp/n:ICMS/n:CST90/n:vICMS,'##.##.##0,00')" />
                      </xsl:when>
                    </xsl:choose>
                  </span>
                </td>
                <td valign="top" width="34%">
                  <span class="TextoFundoBrancoNegrito">
                    Valor Total do Servio<br />
                  </span>
                  <span class="linhaCinza">
                    <xsl:value-of select="format-number(/n:cteProc/n:CTe/n:infCte/n:vPrest/n:vTPrest,'##.##.##0,00')" />
                  </span>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td class="Aviso" colspan="3">
            <div align="center">
              Vlida somente com a apresentao conjunta do DACTE (Documento Auxiliar do Conhecimento de Transporte Eletrnico)
            </div>
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>
</xsl:stylesheet>
