﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:cte="http://www.portalfiscal.inf.br/cte">
  <xsl:import href="aereo.xslt" />
  <xsl:import href="anulacao.xslt" />
  <xsl:import href="aquaviario.xslt" />
  <xsl:import href="carga.xslt" />
  <xsl:import href="complementar.xslt" />
  <xsl:import href="complementar.xslt" />
  <xsl:import href="cte.xslt" />
  <xsl:import href="destinatario.xslt" />
  <xsl:import href="dutoviario.xslt" />
  <xsl:import href="emitente.xslt" />
  <xsl:import href="expedidor.xslt" />
  <xsl:import href="ferroviario.xslt" />
  <xsl:import href="header.xslt" />
  <xsl:import href="informacoes_adicionais.xslt" />
  <xsl:import href="recebedor.xslt" />
  <xsl:import href="remetente.xslt" />
  <xsl:import href="rodoviario.xslt" />
  <xsl:import href="substituto.xslt" />
  <xsl:import href="tomador.xslt" />
  <xsl:import href="totais.xslt" />
  
  <xsl:output method="xml" indent="yes"/>

  <xsl:template name="footer">
    <xsl:param name="tipo" />
    <xsl:param name="titulo" />
    <div>
      <table cellspacing="0" cellpadding="10" width="100%" align="center" border="0">
        <tr>
          <td>
            <input type="button" class="button" value="Nova Consulta" onclick="NovaConsulta('Cte_ConsultaPrincipal.aspx');" />
          </td>
          <td align="left" style="width:100%;">
            <input type="button" class="button" value="Imprimir Dados {$titulo}" onclick="ShowPrint({$tipo});" />
          </td>
          <td align="right">
            <input type="button" class="button" value="Exibir Autorização de uso" onclick="ShowAutorizacao();" />
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>
  
  <xsl:template match="/">
    <table width="98%" align="center" cellspacing="0" cellpadding="0">
      <tr>
        <td align="right">
          <img src="../img/print.gif" alt="Preparar para impressão" style="cursor: hand;" onclick="javascript:ShowPrint();" />
          <div style="display: none;">
            <input type="text" id="chaveAcesso" />
          </div>
        </td>
      </tr>
    </table>
    <div id="tabs" class="Principal">
      <xsl:call-template name="header" />
      
      <br />
      <!-- Abas -->
      <ul>
        <li>
          <a href="#cte">CT-e</a>
        </li>
        <li>
          <a href="#emitente">Emitente</a>
        </li>
        <li>
          <a href="#tomador">Tomador</a>
        </li>
        <li>
          <a href="#remetente">Remetente</a>
        </li>
        <li>
          <a href="#destinatario">Destinatário</a>
        </li>
        <xsl:if test="/cte:CTe/cte:infCte/cte:exped != ''">
          <li>
            <a href="#expedidor">Expedidor</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:receb != ''">
          <li>
            <a href="#recebedor">Recebedor</a>
          </li>
        </xsl:if>
        <li>
          <a href="#totais">Totais</a>
        </li>
        <li>
          <a href="#carga">Carga</a>
        </li>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:rodo != ''">
          <li>
            <a href="#rodoviario">Rodoviário</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:aereo != ''">
          <li>
            <a href="#aereo">Aéreo</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:aquav != ''">
          <li>
            <a href="#aquaviario">Aquaviário</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:duto != ''">
          <li>
            <a href="#dutoviario">Dutoviário</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:ferrov != ''">        
          <li>
            <a href="#ferroviario">Ferroviário</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCteComp != ''">
          <li>
            <a href="#complementar">Complemento</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infCteAnuEnt != ''">
          <li>
            <a href="#anulacao">Anulação</a>
          </li>
        </xsl:if>
        <xsl:if test="/cte:CTe/cte:infCte/cte:infAdCteSub != ''">
          <li>
            <a href="#substituto">Substituto</a>
          </li>
        </xsl:if>
        <li>
          <a href="#informacoes_adicionais">
            <div nowRap="true">
              Inf. Adicionais
            </div>
          </a>
        </li>
      </ul>
      <div id="cte">
        <xsl:call-template name="cte" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,2]'" />
          <xsl:with-param name="titulo" select="'do CT-e'" />
        </xsl:call-template>
      </div>
      <div id="emitente">
        <xsl:call-template name="emitente" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,3]'" />
          <xsl:with-param name="titulo" select="'do Emitente'" />
        </xsl:call-template>
      </div>
      <xsl:if test="/cte:CTe/cte:infCte/cte:exped != ''">
        <div id="expedidor">
          <xsl:call-template name="expedidor" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,4]'" />
            <xsl:with-param name="titulo" select="'do Expedidor'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <div id="tomador">
        <xsl:call-template name="tomador2" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,5]'" />
          <xsl:with-param name="titulo" select="'do Tomador'" />
        </xsl:call-template>
      </div>
      <div id="remetente">
        <xsl:call-template name="remetente" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,6]'" />
          <xsl:with-param name="titulo" select="'do Remetente'" />
        </xsl:call-template>
      </div>
      <xsl:if test="/cte:CTe/cte:infCte/cte:dest != ''">
        <div id="destinatario">
          <xsl:call-template name="destinatario" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,7]'" />
            <xsl:with-param name="titulo" select="'do Destinatário'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:receb != ''">
        <div id="recebedor">
          <xsl:call-template name="recebedor" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,8]'" />
            <xsl:with-param name="titulo" select="'do Recebedor'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <div id="totais">
        <xsl:call-template name="totais" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,9]'" />
          <xsl:with-param name="titulo" select="'Totais'" />
        </xsl:call-template>
      </div>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCteComp != ''">
        <div id="complementar">
          <xsl:call-template name="complementar" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,10]'" />
            <xsl:with-param name="titulo" select="'do Complemento'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <div id="carga">
        <xsl:call-template name="carga" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,11]'" />
          <xsl:with-param name="titulo" select="'da Carga'" />
        </xsl:call-template>
      </div>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCteAnuEnt != ''">
        <div id="anulacao">
          <xsl:call-template name="anulacao" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,12]'" />
            <xsl:with-param name="titulo" select="'da Anulação'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:rodo != ''">
        <div id="rodoviario">
          <xsl:call-template name="rodoviario" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,13]'" />
            <xsl:with-param name="titulo" select="'do Rodoviário'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:aereo != ''">
        <div id="aereo">
          <xsl:call-template name="aereo" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,14]'" />
            <xsl:with-param name="titulo" select="'do Aéreo'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:aquav != ''">
        <div id="aquaviario">
          <xsl:call-template name="aquaviario" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,15]'" />
            <xsl:with-param name="titulo" select="'do Aquaviário'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:duto != ''">
        <div id="dutoviario">
          <xsl:call-template name="dutoviario" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,16]'" />
            <xsl:with-param name="titulo" select="'do Dutoviário'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:ferrov != ''">
        <div id="ferroviario">
          <xsl:call-template name="ferroviario" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,17]'" />
            <xsl:with-param name="titulo" select="'do Ferroviário'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <xsl:if test="/cte:CTe/cte:infCte/cte:infAdCteSub != ''">
        <div id="substituto">
          <xsl:call-template name="substituto" />
          <xsl:call-template name="footer">
            <xsl:with-param name="tipo" select="'[1,18]'" />
            <xsl:with-param name="titulo" select="'do Substitúto'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <div id="informacoes_adicionais">
        <xsl:call-template name="informacoes_adicionais" />
        <xsl:call-template name="footer">
          <xsl:with-param name="tipo" select="'[1,19]'" />
          <xsl:with-param name="titulo" select="'de Informações Gerais'" />
        </xsl:call-template>
      </div>
    </div>    
  </xsl:template>
</xsl:stylesheet>