<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="aereo" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:aereo" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="aereo">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Aéreo'" /></xsl:call-template>
        <div class="header">INFORMAÇÕES</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="25%">Minuta</th>
                <th width="25%">Conhecimento Aéreo</th>
                <th width="25%">Data Prevista Entrega</th>
                <th width="25%">Código IATA</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$aereo/cte:nMinu" /></td>
                <td><xsl:value-of select="$aereo/cte:nOCA" /></td>
                <td><xsl:call-template name="format-date"><xsl:with-param name="date" select="$aereo/cte:dPrev" /></xsl:call-template></td>
                <td><xsl:value-of select="$aereo/cte:cIATA" /></td>
            </tr>
            <tr>
                <th colspan="4">Loja Ag. Emissor</th>
            </tr>
            <tr>
                <td colspan="4"><xsl:value-of select="$aereo/cte:xLAgEmi" /></td>
            </tr>
        </table>

        <div class="header">TARIFA</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="25%">Trecho</th>
                <th width="25%">CL</th>
                <th width="25%">Código</th>
                <th width="25%">Valor</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$aereo/cte:tarifa/cte:trecho" /></td>
                <td><xsl:value-of select="$aereo/cte:tarifa/cte:CL" /></td>
                <td><xsl:value-of select="$aereo/cte:tarifa/cte:cTar" /></td>
                <td>
                    <xsl:call-template name="decimal">
                        <xsl:with-param name="value" select="$aereo/cte:tarifa/cte:vTar" />
                    </xsl:call-template>
                </td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>