<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="anula" select="/cte:CTe/cte:infCte/cte:infCteAnuEnt" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="anulacao">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Anulação'" /></xsl:call-template>
        <div class="header">DETALHAMENTO DA ANULAÇÃO DE DÉBITO</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Chave de Acesso do CT-e Anulado</th>
                <th width="50%">Data Emissão Declaração do Tomador</th>
            </tr>
            <xsl:for-each select="$anula">
                <tr>
                    <td><xsl:call-template name="format-chave-acesso"><xsl:with-param name="chave" select="cte:chCte"/></xsl:call-template></td>
                    <td><xsl:call-template name="format-date"><xsl:with-param name="date" select="cte:dEmi" /></xsl:call-template></td>
                </tr>
            </xsl:for-each>
        </table>
    </xsl:template>
</xsl:stylesheet>