<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="dest" select="/cte:CTe/cte:infCte/cte:dest" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="destinatario">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Dados do Destinatário'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th colspan="2">Nome / Razão Social</th>
            </tr>
            <tr>
                <td colspan="2"><xsl:value-of select="$dest/cte:xNome" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th width="50%"><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$dest" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                <th width="50%">Inscrição Estadual</th>
            </tr>
            <tr>
                <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$dest" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                <td><xsl:value-of select="$dest/cte:IE" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Endereço</th>
                <th>Bairro / Distrito</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-ender"><xsl:with-param name="root" select="$dest" /></xsl:call-template></td>
                <td><xsl:value-of select="$dest/descendant::cte:xBairro" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Fone / Fax</th>
                <th>CEP</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-phone"><xsl:with-param name="phone" select="$dest/cte:fone" /></xsl:call-template></td>
                <td><xsl:call-template name="format-cep"><xsl:with-param name="cep" select="$dest/descendant::cte:CEP" /></xsl:call-template></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Município</th>
                <th>UF</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$dest/descendant::cte:xMun" /></td>
                <td><xsl:value-of select="$dest/descendant::cte:UF" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>País</th>
                <th>Inscrição SUFRAMA</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$dest/descendant::cte:xPais" /></td>
                <td><xsl:value-of select="$dest/cte:ISUF" /></td>
            </tr>
        </table>
        
        <xsl:if test="count($dest/cte:locEnt) &gt; 0">
            <div class="header">LOCAL DE ENTREGA</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="50%"><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$dest/cte:locEnt" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                    <th width="50%">Nome / Razão Social</th>
                </tr>
                <tr>
                    <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$dest/cte:locEnt" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                    <td><xsl:value-of select="$dest/cte:locEnt/cte:xNome" /></td>
                </tr>
                <tr>
                    <th>Endereço</th>
                    <th>Bairro</th>
                </tr>
                <tr>
                    <td><xsl:call-template name="format-ender"><xsl:with-param name="root" select="$dest/cte:locEnt" /></xsl:call-template></td>
                    <td><xsl:value-of select="$dest/cte:locEnt/cte:xBairro" /></td>
                </tr>
                <tr>
                    <th>Município</th>
                    <th>UF</th>
                </tr>
                <tr>
                    <td><xsl:value-of select="$dest/cte:locEnt/cte:xMun" /></td>
                    <td><xsl:value-of select="$dest/cte:locEnt/cte:UF" /></td>
                </tr>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>