<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
  <xsl:variable name="emit" select="/cte:CTe/cte:infCte/cte:emit" />
  <xsl:include href="../functions.xslt"/>

  <xsl:template match="/" name="emitente">
    <xsl:call-template name="group">
      <xsl:with-param name="label" select="'Dados do Emitente'" />
    </xsl:call-template>
    <table class="table" cellpadding="2" cellspacing="1">
      <tr>
        <th width="50%">Nome / Razão Social</th>
        <th width="50%">Nome Fantasia</th>
      </tr>
      <tr>
        <td>
          <xsl:value-of select="$emit/cte:xNome" />
        </td>
        <td>
          <xsl:value-of select="$emit/cte:xFant" />
        </td>
      </tr>
      <tr>
        <th>&#160;</th>
      </tr>
      <tr>
        <th>CNPJ</th>
        <th>Inscrição Estadual</th>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="format-cnpj">
            <xsl:with-param name="cnpj" select="$emit/cte:CNPJ" />
          </xsl:call-template>
        </td>
        <td>
          <xsl:value-of select="$emit/cte:IE" />
        </td>
      </tr>
      <tr>
        <th>&#160;</th>
      </tr>
      <tr>
        <th>Endereço</th>
        <th>Bairro / Distrito</th>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="format-ender">
            <xsl:with-param name="root" select="$emit" />
          </xsl:call-template>
        </td>
        <td>
          <xsl:value-of select="$emit/descendant::cte:xBairro" />
        </td>
      </tr>
      <tr>
        <th>&#160;</th>
      </tr>
      <tr>
        <th>Fone / Fax</th>
        <th>CEP</th>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="format-phone">
            <xsl:with-param name="phone" select="$emit/descendant::cte:fone" />
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="format-cep">
            <xsl:with-param name="cep" select="$emit/descendant::cte:CEP" />
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <th>&#160;</th>
      </tr>
      <tr>
        <th>Município</th>
        <th>UF</th>
      </tr>
      <tr>
        <td>
          <xsl:value-of select="$emit/descendant::cte:xMun" />
        </td>
        <td>
          <xsl:value-of select="$emit/descendant::cte:UF" />
        </td>
      </tr>
      <tr>
        <th>&#160;</th>
      </tr>
      <tr>
        <th colspan="2">País</th>
      </tr>
      <tr>
        <td colspan="2">
          <xsl:value-of select="$emit/descendant::cte:xPais" />
        </td>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>