<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="rem" select="/cte:CTe/cte:infCte/cte:rem" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="remetente">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Dados do Remetente'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Nome / Razão Social</th>
                <th width="50%">Nome Fantasia</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$rem/cte:xNome" /></td>
                <td><xsl:value-of select="$rem/cte:xFant" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$rem" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                <th>Inscrição Estadual</th>
            </tr>
            <tr>
                <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$rem" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                <td><xsl:value-of select="$rem/cte:IE" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Endereço</th>
                <th>Bairro / Distrito</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-ender"><xsl:with-param name="root" select="$rem" /></xsl:call-template></td>
                <td><xsl:value-of select="$rem/descendant::cte:xBairro" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Fone / Fax</th>
                <th>CEP</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-phone"><xsl:with-param name="phone" select="$rem/cte:fone" /></xsl:call-template></td>
                <td><xsl:call-template name="format-cep"><xsl:with-param name="cep" select="$rem/descendant::cte:CEP" /></xsl:call-template></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Município</th>
                <th>UF</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$rem/descendant::cte:xMun" /></td>
                <td><xsl:value-of select="$rem/descendant::cte:UF" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th colspan="2">País</th>
            </tr>
            <tr>
                <td colspan="2"><xsl:value-of select="$rem/descendant::cte:xPais" /></td>
            </tr>
        </table>
        
        <!-- EXIBIÇÃO DE NOTAS FISCAIS -->
        <xsl:if test="count($rem/cte:infNF) &gt; 0">
            <div class="header">
                <img id="imgRemetente" onclick="showArea('tbNF', this);" class="pointer" src="" />
                INFORMAÇÕES DE NOTAS FISCAIS
            </div>
            <table id="tbNF" cellpadding="2" cellspacing="1" class="hide">
                <tr>
                    <th width="25%">Número</th>
                    <th width="10%">Série</th>
                    <th width="20%">Valor Nota Fiscal</th>
                    <th width="15%">Valor BC ICMS</th>
                    <th width="15%">Valor ICMS</th>                    
                    <th width="15%">Valor ICMS ST</th>
                </tr>
                <xsl:for-each select="$rem/cte:infNF">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:value-of select="cte:nDoc" /></td>
                        <td><xsl:value-of select="cte:serie" /></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vNF" /></xsl:call-template></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vBC" /></xsl:call-template></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vICMS" /></xsl:call-template></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vST" /></xsl:call-template></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
        
        <!-- EXIBIÇÃO DE NOTAS FISCAIS ELETRÔNICAS -->
        <xsl:if test="count($rem/cte:infNFe) &gt; 0">
            <div class="header">
                <img onclick="showArea('tbNFe', this);" class="pointer" />
                INFORMAÇÕES DE NOTAS FISCAIS ELETRÔNICAS
            </div>
            <table id="tbNFe" cellpadding="2" cellspacing="1" class="hide">
                <tr>
                    <th>Chave de Acesso</th>
                </tr>
                <xsl:for-each select="$rem/cte:infNFe">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td>
                            <xsl:call-template name="format-chave-acesso">
                                <xsl:with-param name="chave" select="cte:chave" />
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
        
        <!-- EXIBIÇÃO DE OUTRAS NOTAS -->
        <xsl:if test="count($rem/cte:infOutros) &gt; 0">
            <div class="header">
                <img onclick="showArea('tbNFo', this);" class="pointer" />
                INFORMAÇÕES DE OUTROS DOCUMENTOS
            </div>
            <table id="tbNFo" cellpadding="2" cellspacing="1" class="hide">
                <tr>
                    <th width="20%">Tipo</th>
                    <th width="40%">Descrição</th>
                    <th width="20%">Número</th>
                    <th width="20%">Valor</th>
                </tr>
                <xsl:for-each select="$rem/cte:infOutros">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:value-of select="cte:tpDoc" /></td>
                        <td><xsl:value-of select="cte:descOutros" /></td>
                        <td><xsl:value-of select="cte:nDoc" /></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vDocFisc" /></xsl:call-template></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>