<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="rodo" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:rodo" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="rodoviario">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Rodoviário'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="25%">RNTRC</th>
                <th width="25%">Data Entrega</th>
                <th width="25%">Lotação</th>
                <th width="25%">CTRB</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$rodo/cte:RNTRC" /></td>
                <td><xsl:call-template name="format-date"><xsl:with-param name="date" select="$rodo/cte:dPrev" /></xsl:call-template></td>
                <td><xsl:value-of select="$rodo/cte:lota" /></td>
                <td>
                    <xsl:if test="count($rodo/cte:CTRB) &gt; 0">
                        <xsl:value-of select="$rodo/cte:CTRB/cte:serie" /> - <xsl:value-of select="$rodo/cte:CTRB/cte:nCTRB" />
                    </xsl:if>
                </td>
            </tr>
        </table>

        <!-- TABELA DE VEÍCULOS -->
        <xsl:if test="count($rodo/cte:veic) &gt; 0">
            <div class="header">VEÍCULOS</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="25%">Renavam</th>
                    <th width="25%">Placa</th>
                    <th width="25%">Tara</th>
                    <th width="25%">UF Licenciamento</th>
                </tr>
                <xsl:for-each select="$rodo/cte:veic">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:value-of select="cte:RENAVAM" /></td>
                        <td><xsl:value-of select="cte:placa" /></td>
                        <td><xsl:value-of select="cte:tara" /></td>
                        <td><xsl:value-of select="cte:UF" /></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>

        <!-- TABELA DE PROPRIETÁRIOS -->
        <xsl:if test="count($rodo/cte:veic/cte:prop) &gt; 0">
            <div class="header">PROPRIETÁRIOS</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="30%"><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$rodo/cte:veic/cte:prop" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                    <th width="40%">Nome/Razão Social</th>
                    <th width="30%">RNTRC</th>
                </tr>
                <tr>
                    <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$rodo/cte:veic/cte:prop" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                    <td><xsl:value-of select="$rodo/cte:veic/cte:prop/cte:xNome" /></td>
                    <td><xsl:value-of select="$rodo/cte:veic/cte:prop/cte:RNTRC" /></td>
                </tr>
            </table>
        </xsl:if>
        
        <!-- TABELA DE MOTORISTAS -->
        <xsl:if test="count($rodo/cte:moto) &gt; 0">
            <div class="header">MOTORISTAS</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="50%">CPF</th>
                    <th width="50%">NOME</th>
                </tr>
                <xsl:for-each select="$rodo/cte:moto">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:call-template name="format-cpf"><xsl:with-param name="cpf" select="cte:CPF" /></xsl:call-template></td>
                        <td><xsl:value-of select="cte:xNome" /></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>