<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="subst" select="/cte:CTe/cte:infCte/cte:infAdCteSub" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="substituto">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Substituto'" /></xsl:call-template>
        <div class="header">DETALHAMENTO</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th>Chave Acesso</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-chave-acesso"><xsl:with-param name="chave" select="$subst/cte:chCTe"/></xsl:call-template></td>
            </tr>
        </table>

        <xsl:if test="count($subst/cte:refNFe) &gt; 0 or count($subst/cte:refCTe) &gt; 0">
            <div class="header">DOCUMENTO EMITIDO PELO TOMADOR (ELETRÔNICO)</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th>Tipo</th>
                    <th>Chave Acesso</th>
                </tr>
                <tr>
                    <xsl:choose>
                        <xsl:when test="count($subst/cte:refCte) &gt; 0">">
                            <td>CT-e</td>
                            <td><xsl:call-template name="format-chave-acesso"><xsl:with-param name="chave" select="$subst/cte:refCte"/></xsl:call-template></td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td>NF-e</td>
                            <td><xsl:call-template name="format-chave-acesso"><xsl:with-param name="chave" select="$subst/cte:refNFe"/></xsl:call-template></td>
                        </xsl:otherwise>
                    </xsl:choose>
                </tr>
            </table>
        </xsl:if>

        <xsl:if test="count($subst/cte:refNF) &gt; 0">
            <div class="header">DOCUMENTO EMITIDO PELO TOMADOR (PAPEL)</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th>CNPJ</th>
                    <th width="10%">Mod</th>
                    <th width="10%">Série</th>
                    <th width="10%">Subsérie</th>
                    <th width="10%">Número</th>
                    <th width="10%">Valor</th>
                    <th width="20%">Data de Emissão</th>
                </tr>
                <tr>
                    <td><xsl:call-template name="format-cnpj"><xsl:with-param name="cnpj" select="$subst/cte:refNF/cte:CNPJ"/></xsl:call-template></td>
                    <td><xsl:value-of select="$subst/cte:refNF/cte:mod" /></td>
                    <td><xsl:value-of select="$subst/cte:refNF/cte:serie" /></td>
                    <td><xsl:value-of select="$subst/cte:refNF/cte:subserie" /></td>
                    <td><xsl:value-of select="$subst/cte:refNF/cte:nro" /></td>
                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="$subst/cte:refNF/cte:valor" /></xsl:call-template></td>
                    <td><xsl:call-template name="format-date"><xsl:with-param name="date" select="$subst/cte:refNF/cte:dEmi" /></xsl:call-template></td>
                </tr>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>