<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="aqua" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:aquav" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="aquaviario">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Aquaviário'" /></xsl:call-template>
        <div class="header">ADICIONAL DE FRETE PARA RENOVAÇÂO MARINHA MERCANTE</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Valor BC AFRMM</th>
                <th width="50%">Valor AFRMM</th>
            </tr>
            <tr>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="$aqua/cte:vPrest" /></xsl:call-template></td>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="$aqua/cte:vAFRMN" /></xsl:call-template></td>
            </tr>
        </table>

        <div class="header">VIAGEM</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Número</th>
                <th width="50%">Direção</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$aqua /cte:nViag" /></td>
                <td>
                    <xsl:choose>
                        <xsl:when test="$aqua/cte:direc = 'N'">N - Norte</xsl:when>
                        <xsl:when test="$aqua/cte:direc = 'S'">S - Sul</xsl:when>
                        <xsl:when test="$aqua/cte:direc = 'L'">L - Leste</xsl:when>
                        <xsl:when test="$aqua/cte:direc = 'O'">O - Oeste</xsl:when>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <th colspan="2">Navio</th>
            </tr>
            <tr>
                <td colspan="2"><xsl:value-of select="$aqua/cte:xNavio" /></td>
            </tr>
            <tr>
                <th>Porto Embarque</th>
                <th>Porto Transbordo</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$aqua/cte:prtEmb" /></td>
                <td><xsl:value-of select="$aqua/cte:prtTrans" /></td>
            </tr>
            <tr>
                <th>Porto Destino</th>
                <th>Tipo Navegação</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$aqua/cte:prtDest" /></td>
                <td>
                    <xsl:choose>
                        <xsl:when test="$aqua/cte:tpNav = 0">0 - Interior</xsl:when>
                        <xsl:when test="$aqua/cte:tpNav = 1">1 - Cabotagem</xsl:when>
                    </xsl:choose>
                </td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>