<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="carga" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:infCarga" />
    <xsl:variable name="veicNovos" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:veicNovos" />
    <xsl:variable name="peri" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:peri" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="carga">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Carga'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="30%">Valor Total Mercadoria</th>
                <th width="40%">Produto Predominante</th>
                <th width="30%">Outras Características</th>
            </tr>
            <tr>
                <td>
                    <xsl:call-template name="decimal">
                        <xsl:with-param name="value" select="$carga/cte:vMerc" />
                        <xsl:with-param name="count" select="2" />
                    </xsl:call-template>
                </td>
                <td><xsl:value-of select="$carga/cte:proPred" /></td>
                <td><xsl:value-of select="$carga/cte:xOutCat" /></td>
            </tr>
        </table>

        <div class="header">QUANTIDADES DE CARGA</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="30%">Unidade</th>
                <th width="40%">Medida</th>
                <th width="30%">Quantidade</th>
            </tr>
            <xsl:for-each select="$carga/cte:infQ">
                <xsl:variable name="line">
                    <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                </xsl:variable>
                <tr class="{$line}">
                    <td>
                        <xsl:choose>
                            <xsl:when test="cte:cUnid = 00">00 - M3</xsl:when>
                            <xsl:when test="cte:cUnid = 01">01 - KG</xsl:when>
                            <xsl:when test="cte:cUnid = 02">02 - TON</xsl:when>
                            <xsl:when test="cte:cUnid = 03">03 - UNIDADE</xsl:when>
                            <xsl:when test="cte:cUnid = 04">04 - LITROS</xsl:when>
                        </xsl:choose>
                    </td>
                    <td><xsl:value-of select="cte:tpMed"/></td>
                    <td>
                        <xsl:call-template name="decimal">
                            <xsl:with-param name="value" select="cte:qCarga" />
                            <xsl:with-param name="count" select="4" />
                        </xsl:call-template>
                    </td>
                </tr>
            </xsl:for-each>
        </table>

        <!-- TRATAMENTO DOS CONTAINERS -->
        <xsl:if test="count($carga/parent::*/cte:contQt) &gt; 0">
            <div class="header">CONTAINERS</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="50%">Container</th>
                    <th width="50%">Lacres</th>
                </tr>
                <xsl:for-each select="$carga/parent::*/cte:contQt">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:value-of select="cte:nCont"/></td>
                        <td>
                            <xsl:if test="count(cte:lacContQt) &gt; 0">
                                <select class="combo">
                                    <xsl:for-each select="cte:lacContQt">
                                        <option><xsl:value-of select="cte:nLacre" /></option>
                                    </xsl:for-each>
                                </select>
                            </xsl:if>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>          
        </xsl:if>
        
        <!-- TRATAMENTO DE PRODUTOS PERIGOSOS -->
        <xsl:if test="count($peri) &gt; 0">
            <div class="header">
              <img onclick="expand('trPeri', this);" class="pointer" />              
              PRODUTOS PERIGOSOS</div>
            <table id="trPeri" class="table" cellpadding="2" cellspacing="1" style="width: 100%;">
                <tr>
                    <th width="7%">Nro. ONU</th>
                    <th width="40%">Nome do Produto</th>
                    <th width="8%">Pto Fulgor</th>
                    <th width="20%">Classe e Risco</th>
                    <th width="5%">Embalagem</th>
                    <th width="10%">Qtde Produto</th>
                    <th width="10%">Qtde volumes</th>
                </tr>
                <xsl:for-each select="$peri">
                    <xsl:variable name="count" select="position()" />
                    
                    <!--
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    -->

                    <tr class="even"> <!-- {$line} -->                        
                        <td><xsl:value-of select="cte:nONU"/></td>
                        <td><xsl:value-of select="cte:xNomeAE"/></td>
                        <td><xsl:value-of select="cte:pontoFulgor"/></td>
                        <td align="left"><xsl:value-of select="cte:xClaRisco"/></td>
                        <td align="left"><xsl:value-of select="cte:grEmb"/></td>
                        <td align="left"><xsl:value-of select="cte:qTotProd"/></td>
                        <td align="left"><xsl:value-of select="cte:qVolTipo"/></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
        
        <!-- TRATAMENTO DE VEÍCULOS NOVOS -->
        <xsl:if test="count($veicNovos) &gt; 0">
            <div class="header">VEÍCULOS NOVOS</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="18%">Chassi</th>
                    <th>Modelo</th>
                    <th width="15%">Cor</th>
                    <th width="15%">Valor Unitário</th>
                    <th width="12%">Valor Frete</th>
                </tr>
                <xsl:for-each select="$veicNovos">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:value-of select="cte:chassi"/></td>
                        <td><xsl:value-of select="cte:cMod"/></td>
                        <td><xsl:value-of select="cte:cCor"/> - <xsl:value-of select="cte:xCor"/></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vUnit" /></xsl:call-template></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vFrete" /></xsl:call-template></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>