<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="comp" select="/cte:CTe/cte:infCte/cte:infCteComp" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="complementar">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Complementar'" /></xsl:call-template>
        <div class="header">CT-e COMPLEMENTADO(S)</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="40%">Chave de Acesso</th>
                <th width="20%">Valor Prestação Serviço</th>
                <th width="20%">CST</th>
                <th width="20%">Valor ICMS</th>
            </tr>
            <xsl:for-each select="$comp">
                <tr>
                    <td><xsl:call-template name="format-chave-acesso"><xsl:with-param name="chave" select="cte:chave"/></xsl:call-template></td>
                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vPresComp/cte:vTPrest" /></xsl:call-template></td>
                    <td><xsl:value-of select="descendant::cte:CST"/></td>
                    <td><xsl:value-of select="descendant::cte:vICMS"/></td>
                </tr>
            </xsl:for-each>
        </table>
    </xsl:template>
</xsl:stylesheet>