<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cte="http://www.portalfiscal.inf.br/cte"
    xmlns:sig="http://www.w3.org/2000/09/xmldsig#">
  <xsl:variable name="root" select="/cte:CTe/cte:infCte/cte:ide" />
  <xsl:include href="../functions.xslt"/>

  <xsl:template match="/" name="cte">
    <script language="javascript" type="text/javascript">
      /**
      * Variável para padronização de caminho de imagem.
      */
      var imgMais = '../img/mais.gif';
      var imgMenos = '../img/menos.gif';

      /**
      * Inicialização das imagens
      */
      function inicializacaoImagens() {
      var img = document.getElementById('imgCte');
      if (img.src != ''){
      img.src = imgMais;
      document.getElementById('imgRemetente').src = imgMais;
      }
      }

      /**
      * Exibe a aba selecionada.
      */
      function showArea(id, img) {
      var oArea = document.getElementById(id);
      img.src = (oArea.className.indexOf('hide') != -1 ? imgMenos : imgMais);
      oArea.className = (oArea.className.indexOf('hide') != -1 ? 'show table' : 'hide');
      }

      /**
      * Expande nodo da grid.
      */
      function expand(id, img) {
      var oNode = document.getElementById(id);
      img.src = (oNode.className == 'hide' ? imgMenos : imgMais);
      oNode.className = (oNode.className == 'hide' ? 'row' : 'hide');
      }
    </script>
    <!-- DADOS DA ABA CT-E -->
    <xsl:call-template name="group">
      <xsl:with-param name="label" select="'Dados do CT-e'" />
    </xsl:call-template>
    <table class="table" cellpadding="2" cellspacing="1">
      <tr>
        <th width="40%">Número</th>
        <th width="30%">Série</th>
        <th width="30%">Data Emissão</th>
      </tr>
      <tr>
        <td>
          <xsl:value-of select="$root/cte:nCT" />
        </td>
        <td>
          <xsl:value-of select="$root/cte:serie" />
        </td>
        <td>
          <xsl:call-template name="format-date">
            <xsl:with-param name="date" select="$root/cte:dhEmi"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>

    <div class="header">VALORES</div>
    <table class="table" cellpadding="2" cellspacing="1">
      <tr>
        <th width="30%">Valor Total Serviço</th>
        <th width="30%">Base Cálculo ICMS</th>
        <th width="40%">Valor ICMS</th>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="decimal">
            <xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:vPrest/cte:vTPrest" />
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="decimal">
            <xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:vBC" />
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="decimal">
            <xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:vICMS" />
          </xsl:call-template>
        </td>
      </tr>
    </table>

    <div class="header">EMITENTE</div>
    <xsl:call-template name="get-fields">
      <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:emit"/>
    </xsl:call-template>

    <!-- TRATA O TOMADOR DO SERVIÇO -->
    <div class="header">TOMADOR DO SERVIÇO</div>
    <xsl:choose>
      <xsl:when test="$root/cte:toma03/cte:toma = 0">
        <xsl:call-template name="get-fields">
          <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:rem"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="$root/cte:toma03/cte:toma = 1">
        <xsl:call-template name="get-fields">
          <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:exped"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="$root/cte:toma03/cte:toma = 2">
        <xsl:call-template name="get-fields">
          <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:receb"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="$root/cte:toma03/cte:toma = 3">
        <xsl:call-template name="get-fields">
          <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:dest"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="get-fields">
          <xsl:with-param name="root" select="$root/cte:toma4"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="count(/cte:CTe/cte:infCte/cte:rem) &gt; 0">
      <div class="header">REMETENTE</div>
      <xsl:call-template name="get-fields">
        <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:rem"/>
      </xsl:call-template>
    </xsl:if>

    <xsl:if test="count(/cte:CTe/cte:infCte/cte:dest) &gt; 0">
      <div class="header">DESTINATÁRIO</div>
      <xsl:call-template name="get-fields">
        <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:dest"/>
      </xsl:call-template>
    </xsl:if>

    <xsl:if test="count(/cte:CTe/cte:infCte/cte:exped) &gt; 0">
      <div class="header">EXPEDIDOR</div>
      <xsl:call-template name="get-fields">
        <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:exped"/>
      </xsl:call-template>
    </xsl:if>

    <xsl:if test="count(/cte:CTe/cte:infCte/cte:receb) &gt; 0">
      <div class="header">RECEBEDOR</div>
      <xsl:call-template name="get-fields">
        <xsl:with-param name="root" select="/cte:CTe/cte:infCte/cte:receb"/>
      </xsl:call-template>
    </xsl:if>

    <div class="header">CARACTERÍSTICAS</div>
    <table class="table" cellpadding="2" cellspacing="1">
      <tr>
        <th width="20%">Modal</th>
        <th width="40%">Tipo Serviço</th>
        <th width="20%">Finalidade</th>
        <th width="20%">Forma</th>
      </tr>
      <tr>
        <td>
          <!-- MODAL -->
          <xsl:choose>
            <xsl:when test="$root/cte:modal = 1">Rodoviário</xsl:when>
            <xsl:when test="$root/cte:modal = 2">Aéreo</xsl:when>
            <xsl:when test="$root/cte:modal = 3">Aquaviário</xsl:when>
            <xsl:when test="$root/cte:modal = 4">Ferroviário</xsl:when>
            <xsl:when test="$root/cte:modal = 5">Dutoviário</xsl:when>
          </xsl:choose>
        </td>
        <td>
          <!-- TIPO DO SERVIÇO -->
          <xsl:choose>
            <xsl:when test="$root/cte:tpServ = 0">Normal</xsl:when>
            <xsl:when test="$root/cte:tpServ = 1">Subcontratação</xsl:when>
            <xsl:when test="$root/cte:tpServ = 2">Redespacho</xsl:when>
            <xsl:when test="$root/cte:tpServ = 3">Redespacho intermediário</xsl:when>
          </xsl:choose>
        </td>
        <td>
          <!-- TIPO DO CONHECIMENTO DE TRANSPORTE -->
          <xsl:choose>
            <xsl:when test="$root/cte:tpCTe = 0">CT-e Normal</xsl:when>
            <xsl:when test="$root/cte:tpCTe = 1">CT-e de Complemento de Valores</xsl:when>
            <xsl:when test="$root/cte:tpCTe = 2">CT-e de Anulação de Valores</xsl:when>
            <xsl:when test="$root/cte:tpCTe = 3">CT-e Substituto do CT-e Anulado</xsl:when>
          </xsl:choose>
        </td>
        <td>
          <!-- FORMA DE EMISSÃO -->
          <xsl:choose>
            <xsl:when test="$root/cte:tpEmis = 1">Normal</xsl:when>
            <xsl:when test="$root/cte:tpEmis = 2">Contingência</xsl:when>
          </xsl:choose>
        </td>
      </tr>
      <tr>
        <th>CFOP</th>
        <th>Natureza da Prestação</th>
        <th colspan="2">Digest Value do CT-e</th>
      </tr>
      <tr>
        <td>
          <xsl:value-of select="$root/cte:CFOP" />
        </td>
        <td>
          <xsl:value-of select="$root/cte:natOp" />
        </td>
        <td colspan="2">
          <xsl:value-of select="/*/sig:Signature/sig:SignedInfo/sig:Reference/sig:DigestValue"/>
        </td>
      </tr>
      <tr>
        <th colspan="2">Início da Prestação</th>
        <th colspan="2">Fim da Prestação</th>
      </tr>
      <tr>
        <td colspan="2">
          <xsl:value-of select="$root/cte:UFEmi" /> - <xsl:value-of select="$root/cte:xMunIni" />
        </td>
        <td colspan="2">
          <xsl:value-of select="$root/cte:UFFim" /> - <xsl:value-of select="$root/cte:xMunFim" />
        </td>
      </tr>
    </table>

    <div class="header">
      <img id="imgCte" onclick="showArea('tbSituacao', this);" class="pointer" src="" />
      SITUAÇÃO ATUAL :
      <xsl:choose>
        <xsl:when test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 1">AUTORIZADO</xsl:when>
        <xsl:when test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 2">INUTILIZADO</xsl:when>
        <xsl:when test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 3">CANCELADO</xsl:when>
        <xsl:otherwise>SITUAÇÃO NÃO LOCALIZADA</xsl:otherwise>
      </xsl:choose>
    </div>
    <table id="tbSituacao" class="hide" cellpadding="2" cellspacing="1">
      <tr>
        <th width="30%">Protocolo</th>
        <th width="30%">Data</th>
        <th width="40%">Situação</th>
      </tr>
      <tr>
        <td>
          <xsl:value-of select="/cte:CTe/cte:infCte/cte:infAd/cte:prot"/>
        </td>
        <td>
          <xsl:call-template name="format-date">
            <xsl:with-param name="date" select="/cte:CTe/cte:infCte/cte:infAd/cte:dCte"/>
          </xsl:call-template>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 1">Autorizado</xsl:when>
            <xsl:when test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 2">Não Autorizado</xsl:when>
            <xsl:when test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 3">Cancelado</xsl:when>
            <xsl:otherwise>Situação Não Localizada</xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
      <!-- CASO CANCELADO -->
      <xsl:if test="/cte:CTe/cte:infCte/cte:infAd/cte:sit = 3">
        <tr>
          <td>
            <xsl:value-of select="/cte:CTe/cte:infCte/cte:infAd/cte:protAut"/>
          </td>
          <td>
            <xsl:call-template name="format-date">
              <xsl:with-param name="date" select="/cte:CTe/cte:infCte/cte:infAd/cte:dAut"/>
            </xsl:call-template>
          </td>
          <td>Autorização Cancelada</td>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>
</xsl:stylesheet>