<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="ferro" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:ferrov" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="ferroviario">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Ferroviário'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Tipo Tráfego</th>
                <th width="50%">Fluxo</th>
            </tr>
            <tr>
                <td>
                    <xsl:choose>
                        <xsl:when test="$ferro/cte:tpTraf = 0">0 - Próprio</xsl:when>
                        <xsl:when test="$ferro/cte:tpTraf = 1">1 - Mútuo</xsl:when>
                        <xsl:when test="$ferro/cte:tpTraf = 2">2 - Rodoferroviário</xsl:when>
                        <xsl:when test="$ferro/cte:tpTraf = 5">5 - Rodoviário</xsl:when>
                    </xsl:choose>
                </td>
                <td><xsl:value-of select="$ferro/cte:fluxo" /></td>
            </tr>
        </table>

        <div class="header">VAGÕES</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="15%">Número</th>
                <th width="15%">Tipo Vagão</th>
                <th width="15%">Peso Real (t)</th>
                <th width="15%">Peso BC (t)</th>
                <th width="20%">Lacre Vagões</th>
                <th width="20%">Container</th>
            </tr>
            <xsl:for-each select="$ferro/cte:detVag">
                <tr>
                    <td><xsl:value-of select="cte:nVag"/></td>
                    <td><xsl:value-of select="cte:tpVag"/></td>
                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:pesoR" /></xsl:call-template></td>
                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:pesoBC" /></xsl:call-template></td>
                    <td>
                        <xsl:if test="count(cte:lacDetVag) &gt; 0">
                            <select class="combo">
                                <xsl:for-each select="cte:lacDetVag">
                                    <option><xsl:value-of select="cte:nLacre" /></option>
                                </xsl:for-each>
                            </select>
                        </xsl:if>
                    </td>
                    <td>
                        <xsl:for-each select="cte:contVag">
                            <xsl:value-of select="cte:nCont" /><br/>
                        </xsl:for-each>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        
        <!-- TRATAMENTO DE DCL -->
        <xsl:if test="count($ferro/cte:DCL) &gt; 0">
            <div class="header">DCL (DESPACHO DE CARGAS EM LOTAÇÃO)</div>
            
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="1%"></th>
                    <th width="15%">Série</th>
                    <th>Número</th>
                    <th width="20%">Data Emissão</th>
                    <th width="20%">Valor Total</th>
                </tr>
                
                <xsl:for-each select="$ferro/cte:DCL">
                    <xsl:variable name="count" select="cte:nDCL" />
                    
                    <!--
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    -->

                    <tr class="even"> <!--{$line}-->
                        <td><img onclick="expand('trDCL{$count}', this);" class="pointer" /></td>
                        <td><xsl:value-of select="cte:serie"/></td>
                        <td><xsl:value-of select="cte:nDCL"/></td>
                        <td><xsl:call-template name="format-date"><xsl:with-param name="date" select="cte:dEmi" /></xsl:call-template></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vTServ" /></xsl:call-template></td>
                    </tr>
                    <tr id="trDCL{$count}" class="hide">
                        <td colspan="5" class="subcontainer" style="background-color: #FFFFFF;">
                            <table class="table subtable" cellpadding="2" cellspacing="1">
                                <tr>
                                    <th width="40%">Id. Trem</th>
                                    <th width="30%">Qtd. Vagões</th>
                                    <th width="30%">Peso Vagões (t)</th>
                                </tr>
                                <tr>
                                    <td><xsl:value-of select="cte:idTrem"/></td>
                                    <td><xsl:value-of select="cte:qVag"/></td>
                                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:pCalc"/></xsl:call-template></td>
                                </tr>
                                <tr>
                                    <th>Valor Tarifa</th>
                                    <th>Valor Frete</th>
                                    <th>Valor Serviços Acess.</th>
                                </tr>
                                <tr>
                                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vTar"/></xsl:call-template></td>
                                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vFrete"/></xsl:call-template></td>
                                    <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vSAcess"/></xsl:call-template></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>