<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="info" select="/cte:CTe/cte:infCte/cte:infCTeNorm/cte:docAnt/cte:emiDocAnt" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="informacoes_adicionais">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Informações Adicionais'" /></xsl:call-template>
        <!-- BLOCO DE DOCUMENTOS ANTERIORES -->
        <xsl:if test="count($info/descendant::cte:idDocAntPap) &gt; 0">
            <div class="header">DOCUMENTOS ANTERIORES - PAPEL</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="20%"><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$info" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                    <th>Nome</th>
                    <th width="10%">Tipo</th>
                    <th width="7%">Serie</th>
                    <th width="10%">Número</th>
                    <th width="13%">Data Emissão</th>
                </tr>
                <xsl:for-each select="$info/descendant::cte:idDocAntPap">
                    <tr>
                        <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$info" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                        <td><xsl:value-of select="$info/cte:xNome"/></td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="cte:tpDoc = 0">CTRC</xsl:when>
                                <xsl:when test="cte:tpDoc = 1">CTAC</xsl:when>
                                <xsl:when test="cte:tpDoc = 2">ACT</xsl:when>
                                <xsl:when test="cte:tpDoc = 3">NF7</xsl:when>
                                <xsl:when test="cte:tpDoc = 4">NF27</xsl:when>
                                <xsl:when test="cte:tpDoc = 5">Aéreo N</xsl:when>
                                <xsl:when test="cte:tpDoc = 6">CTMC</xsl:when>
                                <xsl:when test="cte:tpDoc = 7">ATRE</xsl:when>
                                <xsl:when test="cte:tpDoc = 8">DTA</xsl:when>
                                <xsl:when test="cte:tpDoc = 9">Aéreo I</xsl:when>
                                <xsl:when test="cte:tpDoc = 10">Carta</xsl:when>
                                <xsl:when test="cte:tpDoc = 11">Avulso</xsl:when>
                                <xsl:when test="cte:tpDoc = 12">TIF</xsl:when>
                                <xsl:otherwise>Outros</xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td><xsl:value-of select="cte:serie"/></td>
                        <td><xsl:value-of select="cte:nDoc"/></td>
                        <td><xsl:call-template name="format-date"><xsl:with-param name="date" select="cte:dEmi" /></xsl:call-template></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>
        
        <!-- BLOCO DE DOCUMENTOS ANTERIORES : ELETRÔNICOS -->
        <xsl:if test="count($info/descendant::cte:idDocAntEle) &gt; 0">
            <div class="header">DOCUMENTOS ANTERIORES - ELETRÔNICOS</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="20%">CNPJ</th>
                    <th width="20%">Nome</th>
                    <th width="60%">Chave Acesso</th>
                </tr>
                <xsl:for-each select="$info/descendant::cte:idDocAntEle">
                    <tr>
                        <td>
                            <xsl:call-template name="trata-pessoa">
                                <xsl:with-param name="type" select="'value'"/>
                                <xsl:with-param name="root" select="$info"/>
                            </xsl:call-template>
                        </td>
                        <td><xsl:value-of select="$info/cte:xNome"/></td>
                        <td><xsl:value-of select="cte:chave"/></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>

        <div class="header">INFORMAÇÕES ADICIONAIS DE INTERESSE DO FISCO</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr><th>Descrição</th></tr>
            <tr><td><xsl:value-of select="/cte:CTe/cte:infCte/cte:imp/cte:infAdFisco"/></td></tr>
        </table>
        
        <div class="header">INFORMAÇÕES COMPLEMENTARES DE INTERESSE DO CONTRIBUINTE</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr><th>Descrição</th></tr>
            <tr><td><xsl:value-of select="/cte:CTe/cte:infCte/cte:compl/cte:xObs"/></td></tr>
        </table>

    </xsl:template>
</xsl:stylesheet>