<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:variable name="receb" select="/cte:CTe/cte:infCte/cte:receb" />
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="recebedor">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Dados do Recebedor'" /></xsl:call-template>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th colspan="2">Nome / Razão Social</th>
            </tr>
            <tr>
                <td colspan="2"><xsl:value-of select="$receb/cte:xNome" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th width="50%"><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$receb" /><xsl:with-param name="type" select="'header'" /></xsl:call-template></th>
                <th width="50%">Inscrição Estadual</th>
            </tr>
            <tr>
                <td><xsl:call-template name="trata-pessoa"><xsl:with-param name="root" select="$receb" /><xsl:with-param name="type" select="'value'" /></xsl:call-template></td>
                <td><xsl:value-of select="$receb/cte:IE" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Endereço</th>
                <th>Bairro / Distrito</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-ender"><xsl:with-param name="root" select="$receb" /></xsl:call-template></td>
                <td><xsl:value-of select="$receb/descendant::cte:xBairro" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Fone / Fax</th>
                <th>CEP</th>
            </tr>
            <tr>
                <td><xsl:call-template name="format-phone"><xsl:with-param name="phone" select="$receb/descendant::cte:fone" /></xsl:call-template></td>
                <td><xsl:call-template name="format-cep"><xsl:with-param name="cep" select="$receb/descendant::cte:CEP" /></xsl:call-template></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th>Município</th>
                <th>UF</th>
            </tr>
            <tr>
                <td><xsl:value-of select="$receb/descendant::cte:xMun" /></td>
                <td><xsl:value-of select="$receb/descendant::cte:UF" /></td>
            </tr>
            <tr><th>&#160;</th></tr>
            <tr>
                <th colspan="2">País</th>
            </tr>
            <tr>
                <td colspan="2"><xsl:value-of select="$receb/descendant::cte:xPais" /></td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>