<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:include href="../functions.xslt"/>
    
    <xsl:variable name="root" select="/cte:CTe/cte:infCte/cte:ide" />
    <xsl:variable name="rem" select="/cte:CTe/cte:infCte/cte:rem" />
    <xsl:variable name="dest" select="/cte:CTe/cte:infCte/cte:dest" />
    <xsl:variable name="exped" select="/cte:CTe/cte:infCte/cte:exped" />
    <xsl:variable name="receb" select="/cte:CTe/cte:infCte/cte:receb" />
    <xsl:variable name="toma4" select="/cte:CTe/cte:infCte/cte:ide/cte:toma4" />
    
    <xsl:template match="/" name="tomador2">
        <xsl:choose>
            <xsl:when test="$root/descendant::cte:toma = 0">
                <xsl:call-template name="tomador"><xsl:with-param name="root" select="$rem" /><xsl:with-param name="label" select="'Remetente'" /></xsl:call-template>
            </xsl:when>
            <xsl:when test="$root/descendant::cte:toma = 1">
                <xsl:call-template name="tomador"><xsl:with-param name="root" select="$exped" /><xsl:with-param name="label" select="'Expedidor'" /></xsl:call-template>
            </xsl:when>
            <xsl:when test="$root/descendant::cte:toma = 2">
                <xsl:call-template name="tomador"><xsl:with-param name="root" select="$receb" /><xsl:with-param name="label" select="'Tomador'" /></xsl:call-template>
            </xsl:when>
            <xsl:when test="$root/descendant::cte:toma = 3">
                <xsl:call-template name="tomador"><xsl:with-param name="root" select="$dest" /><xsl:with-param name="label" select="'Destinatário'" /></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="tomador"><xsl:with-param name="root" select="$toma4" /><xsl:with-param name="label" select="'Outros'" /></xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>