<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cte="http://www.portalfiscal.inf.br/cte">
    <xsl:include href="../functions.xslt"/>
    
    <xsl:template match="/" name="totais">
        <xsl:call-template name="group"><xsl:with-param name="label" select="'Totais'" /></xsl:call-template>
        <div class="header">VALORES</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="50%">Valor Prestação Serviço</th>
                <th width="50%">Valor a Receber</th>
            </tr>
            <tr>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:vPrest/cte:vTPrest" /></xsl:call-template></td>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:vPrest/cte:vRec" /></xsl:call-template></td>
            </tr>
        </table>

        <xsl:if test="count(/cte:CTe/cte:infCte/cte:vPrest/cte:Comp) &gt; 0">
            <div class="header">COMPONENTES DO VALOR DA PRESTAÇÃO DO SERVIÇO</div>
            <table class="table" cellpadding="2" cellspacing="1">
                <tr>
                    <th width="50%">Nome</th>
                    <th width="50%">Valor</th>
                </tr>
                <xsl:for-each select="/cte:CTe/cte:infCte/cte:vPrest/cte:Comp">
                    <xsl:variable name="line">
                        <xsl:choose><xsl:when test="position() mod 2 = 0">odd</xsl:when><xsl:otherwise>even</xsl:otherwise></xsl:choose>
                    </xsl:variable>
                    <tr class="{$line}">
                        <td><xsl:value-of select="cte:xNome"/></td>
                        <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="cte:vComp" /></xsl:call-template></td>
                    </tr>
                </xsl:for-each>
            </table>
        </xsl:if>

        <div class="header">IMPOSTOS</div>
        <table class="table" cellpadding="2" cellspacing="1">
            <tr>
                <th width="40%">Base de Cálculo ICMS</th>
                <th width="30%">Valor do ICMS</th>
                <th width="30%">CST</th>
            </tr>
            <tr>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:vBC" /></xsl:call-template></td>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:vICMS" /></xsl:call-template></td>
                <td><xsl:value-of select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:CST" /></td>
            </tr>
            <tr>
                <th>Aliquota ICMS</th>
                <th>Percentual Redução BC</th>
                <th>Valor do Crédito</th>
            </tr>
            <tr>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:pICMS" /></xsl:call-template> %</td>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:pRedBC" /></xsl:call-template> %</td>
                <td><xsl:call-template name="decimal"><xsl:with-param name="value" select="/cte:CTe/cte:infCte/cte:imp/descendant::cte:vCred" /></xsl:call-template></td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>